
/****************************************************************************
* BACK OUT POLYTRAUMA CHANGES - Jan. 2014 (PII)
****************************************************************************/

/************   Delete Physical Assault from TBIINJURYLIST table.   ************/
DELETE FROM [TBI].[STD_TBIINJURYLIST] WHERE CODE = 'Physical Assault';

/************   Remove [TBI].[TBI_POLYTRAUMA].[PHYSICAL_ASSAULT_INJRY_IND] column   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYSICAL_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [PHYSICAL_ASSAULT_INJRY_IND];

/************   Remove [TBI].[TBI_POLYTRAUMA].[JFK_COMA_RECOVERY] column   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'JFK_COMA_RECOVERY')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [JFK_COMA_RECOVERY];

/************   Remove [TBI].[TBI_POLYTRAUMA].[ENTRY_TYPE_ID] column and key and drop [TBI].[STD_POLYTRAUMA_ENTRY_TYPE] table   ************/
/************   Backout Change #3   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'ENTRY_TYPE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_STD_POLYTRAUMA_ENTRY_TYPE

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN ENTRY_TYPE_ID

-- drop [TBI].[STD_POLYTRAUMA_ENTRY_TYPE] table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_ENTRY_TYPE]') AND type in (N'U'))
DROP TABLE [TBI].[STD_POLYTRAUMA_ENTRY_TYPE]

END
GO

/************   End Backout Change #3   ************/


/************   Backout Change #4   ************/
-- drop TBI.TBI_POLYTRAUMA.IS_FOLLOW_UP column (change 4)
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'IS_FOLLOW_UP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN IS_FOLLOW_UP

/************   End Backout Change #4   ************/


/************   Backout Change #5   ************/
-- drop TBI.TBI_POLYTRAUMA.GENITO_URINARY_INJURIES column (change 5)
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'GENITO_URINARY_INJURIES')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN GENITO_URINARY_INJURIES

/************   End Backout Change #5   ************/


/************   Backout Change #6   ************/
IF (SELECT MAX(ID) FROM TBI.STD_TBIDISCHARGETO) > 5
BEGIN

UPDATE TBI.STD_TBIDISCHARGETO SET [INACTIVE_FLAG] = 0, [INACTIVE_DATE] = NULL WHERE ID < 6;

DELETE FROM TBI.STD_TBIDISCHARGETO WHERE ID > 5;

DBCC CHECKIDENT ('TBI.STD_TBIDISCHARGETO',RESEED, 5);

END

/************   End Backout Change #6   ************/


/************   Backout Change #7   ************/
-- drop TBI.TBI_POLYTRAUMA.SEVERITY_LEVEL_INDEX column (change 7)
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SEVERITY_LEVEL_INDEX_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SEVERITY_LEVEL_INDEX_ID

END
GO

-- drop [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX] table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]') AND type in (N'U'))
DROP TABLE [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]
GO

/************   End Backout Change #7   ************/


/************   Backout Change #8   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DAYS_FROM_ONSET')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN DAYS_FROM_ONSET
GO

/************   End Backout Change #8   ************/


/************   Backout Change #9   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PTRP_PROGRAM')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PTRP_PROGRAM
GO

/************   End Backout Change #9   ************/


-- CHANGE 10 LATER ... CASCADING


/************   Backout Change #11   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PREINJURY_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PREINJURY_RESIDENCE_ID_STD_TBIDISCHARGETO

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PREINJURY_RESIDENCE_ID

END
GO
/************   End Backout Change #11   ************/


-- CHANGE 12 - BELOW - CASCADING


/************   Backout Change #13   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ABILITIES_INITIAL

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ABILITIES_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ABILITIES_FOLLOWUP

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ADJUSTMENT_INITIAL

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ADJUSTMENT_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_ADJUSTMENT_FOLLOWUP

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_PARTICIPATION_INITIAL

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_PARTICIPATION_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_PARTICIPATION_FOLLOWUP

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_TOTAL_INITIAL

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_TOTAL_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_TOTAL_FOLLOWUP

GO
/************   End Backout Change #13   ************/


/************   Backout Change #14   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_Q26_ADMISSION

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_Q26_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN MPAI_Q26_FOLLOWUP

GO
/************   End Backout Change #14   ************/


/************   Backout Change #15   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SATIS_W_LIFE_ADMISSION

/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SATIS_W_LIFE_DC
**/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SATIS_W_LIFE_FOLLOWUP

GO
/************   End Backout Change #15   ************/


/************   Backout Change #16   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PART_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PART_FOLLOWUP

GO
/************   End Backout Change #16   ************/


/************   Backout Change #17   ************/
/**
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN WHO_QOL_ADMISSION
**/
/*** -- Removed by stakeholder
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN WHO_QOL_DC
**/
/**
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN WHO_QOL_FOLLOWUP

GO
**/
/************   End Backout Change #17   ************/


/************   Backout Change #18   ************/
-- remove constraint, delete column, delete data
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_MILITARY_DUTY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_MILITARY_DUTY_STATUS_STD_TBIDSCHRGSTS

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN DC_MILITARY_DUTY_STATUS_ID

END
GO

-- set data back
IF (SELECT MAX(ID) FROM TBI.STD_TBIDSCHRGSTS) > 5
BEGIN

UPDATE TBI.STD_TBIDSCHRGSTS SET [INACTIVE_FLAG] = 0, [INACTIVE_DATE] = NULL WHERE ID < 6;

DELETE FROM TBI.STD_TBIDSCHRGSTS WHERE ID > 5;

DBCC CHECKIDENT ('TBI.STD_TBIDSCHRGSTS',RESEED, 5);

END
GO
/************   End Backout Change #18   ************/


/************   End Backout Change #19   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PERSON_LIVING_DC_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PRI_PERSON_DC_STD_PERSON_LIVING_WITH

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PRI_PERSON_LIVING_DC_ID

END
GO


IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PERSON_LIVING_FOLLOWUP_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PRI_PERSON_FOLLOWUP_STD_PERSON_LIVING_WITH

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PRI_PERSON_LIVING_FOLLOWUP_ID

END
GO

/************   End Backout Change #19   ************/


/************   End Backout Change #20   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_DC_RESIDENCE_ID_STD_TBIDISCHARGETO

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN DC_RESIDENCE_ID

END
GO


IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'FOLLOWUP_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_FOLLOWUP_RESIDENCE_ID_STD_TBIDISCHARGETO

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN FOLLOWUP_RESIDENCE_ID

END
GO

/************   End Backout Change #20   ************/


/************   Backout Change #21   ************/

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_DC_EMPLOY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PRI_DC_STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_SEC_DC_STD_POLYTRAUMA_EMPLOYMENT_STATUS

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PRI_DC_EMPLOY_STATUS_ID
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SEC_DC_EMPLOY_STATUS_ID

END
GO

/************   End Backout Change #21   ************/



/************   Backout Change #10   ************/
-- drop constraint from POLYTRAUMA (PREINJURY_PRIM_PERSON_LIVING_WITH_ID) TO STD_PERSON_LIVING_WITH
-- drop PREINJURY_PRIM_PERSON_LIVING_WITH_ID column
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PREINJURY_PRIM_PERSON_LIVING_WITH_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PREINJURY_PRIM_STD_PERSON_LIVING_WITH

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PREINJURY_PRIM_PERSON_LIVING_WITH_ID

END
GO

-- drop [TBI].[STD_PERSON_LIVING_WITH] table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_PERSON_LIVING_WITH]') AND type in (N'U'))
DROP TABLE [TBI].[STD_PERSON_LIVING_WITH]
GO

/************   End Backout Change #10   ************/


/************   Backout Change #12   ************/
-- drop TBI.TBI_POLYTRAUMA.PRI_PREINJURY_EMPLOY_STATUS_ID column (change 12)
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PREINJURY_EMPLOY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PRI_STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_SEC_STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_PRI_FOLLOWUP_STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_SEC_FOLLOWUP_STD_POLYTRAUMA_EMPLOYMENT_STATUS

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PRI_PREINJURY_EMPLOY_STATUS_ID
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SEC_PREINJURY_EMPLOY_STATUS_ID
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN PRI_FOLLOWUP_EMPLOY_STATUS_ID
ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN SEC_FOLLOWUP_EMPLOY_STATUS_ID

END
GO

-- drop [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS] table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]') AND type in (N'U'))
DROP TABLE [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]
GO

/************   End Backout Change #12   ************/


/************ Backout Change #22  ************/
-- Set Walter Reed and National Naval to inactive and add WRNNMC
IF (SELECT MAX(ID) FROM TBI.STD_TBIFACILITYSRC) > 6
BEGIN

UPDATE TBI.STD_TBIFACILITYSRC SET [INACTIVE_FLAG] = 0, [INACTIVE_DATE] = NULL WHERE ID < 3;

DELETE FROM TBI.STD_TBIFACILITYSRC WHERE ID = 7;
DBCC CHECKIDENT ('TBI.STD_TBIFACILITYSRC',RESEED, 6);

END

/************ End Backout Change #22  ************/